/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.mapui;

import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.canvas.process.IVWProcessCanvasPanel;
import filenet.vw.toolkit.design.mapui.VWDesignerMapToolbar;
import filenet.vw.toolkit.design.mapui.VWDesignerWorkflowMapPane;
import filenet.vw.toolkit.design.mapui.VWDesignerWorkflowScrollPane;
import filenet.vw.toolkit.design.mapui.dialog.VWMapsDialog;
import filenet.vw.toolkit.design.mapui.dialog.VWNewMapDialog;
import filenet.vw.toolkit.design.mapui.resources.VWResource;
import filenet.vw.toolkit.design.palette.VWBaseStepPalettePanel;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.event.IVWMapChangedListener;
import filenet.vw.toolkit.design.property.event.VWMapChangedEvent;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStepUtils;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.event.IVWToolbarActionListener;
import filenet.vw.toolkit.utils.event.VWToolbarActionEvent;
import filenet.vw.toolkit.utils.mapui.VWBaseMapToolbar;
import filenet.vw.toolkit.utils.mapui.VWBaseWorkflowMapPane;
import filenet.vw.toolkit.utils.mapui.VWBaseWorkflowPane;
import filenet.vw.toolkit.utils.mapui.VWMap;
import filenet.vw.toolkit.utils.mapui.VWMapAttribs;
import filenet.vw.toolkit.utils.mapui.VWMapNameUtil;
import filenet.vw.toolkit.utils.mapui.VWPrintableStepProperty;
import filenet.vw.toolkit.utils.mapui.VWPrintableWFProperty;
import filenet.vw.toolkit.utils.mapui.VWWorkflowScrollPane;
import filenet.vw.toolkit.utils.table.VWQuickSort;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;
import javax.swing.JOptionPane;

public class VWDesignerWorkflowPane
extends VWBaseWorkflowPane
implements IVWMapChangedListener,
IVWToolbarActionListener {
    private IVWProcessCanvasPanel m_processCanvasPanel = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWBaseStepPalettePanel m_stepPalettePanel = null;
    private boolean m_bViewOnly = true;

    public void init(IVWProcessCanvasPanel processCanvasPanel, VWBaseStepPalettePanel stepPalettePanel) {
        this.m_processCanvasPanel = processCanvasPanel;
        this.m_stepPalettePanel = stepPalettePanel;
        this.m_authPropertyData = this.m_processCanvasPanel.getAuthPropertyData();
        super.init(this.m_authPropertyData.getToolbarActionNotifier());
        this.m_mapAttribs = this.m_authPropertyData.getMapAttributes();
        this.m_authPropertyData.getMapChangeEventNotifier().addMapChangedListener(this);
        this.m_authPropertyData.getToolbarActionNotifier().addToolbarActionListener(this);
    }

    public static boolean isSystemMap(String mapName) {
        boolean bResult = false;
        if (VWStringUtils.compare(mapName, "Workflow") == 0) {
            bResult = true;
        } else if (VWStringUtils.compare(mapName, "Malfunction") == 0) {
            bResult = true;
        } else if (VWStringUtils.compare(mapName, "Terminate") == 0) {
            bResult = true;
        }
        return bResult;
    }

    public void setViewOnly(boolean bViewOnly) {
        this.m_bViewOnly = bViewOnly;
        ((VWDesignerMapToolbar)this.m_mapToolbar).setViewOnly(bViewOnly);
    }

    public boolean getViewOnly() {
        return this.m_bViewOnly;
    }

    public VWSessionInfo getSessionInfo() {
        if (this.m_authPropertyData != null) {
            return this.m_authPropertyData.getSessionInfo();
        }
        return null;
    }

    public void setWorkflowDefinition(VWWorkflowDefinition workflowDefinition, VWWorkflowDefinition baseWorkflowDefinition) {
        super.setWorkflowDefinition(workflowDefinition, baseWorkflowDefinition);
    }

    public boolean copySelectedItems(boolean bDeleteItems) {
        if (this.m_activeMapPane != null && this.m_activeMapPane instanceof VWDesignerWorkflowMapPane) {
            return ((VWDesignerWorkflowMapPane)this.m_activeMapPane).copySelectedItems(bDeleteItems);
        }
        return false;
    }

    public void pasteCopiedItems(Point pasteOrigin) {
        if (this.m_activeMapPane != null && this.m_activeMapPane instanceof VWDesignerWorkflowMapPane) {
            ((VWDesignerWorkflowMapPane)this.m_activeMapPane).pasteCopiedItems(pasteOrigin);
        }
    }

    public boolean deleteSelectedItems() {
        if (this.m_activeMapPane != null && this.m_activeMapPane instanceof VWDesignerWorkflowMapPane) {
            return ((VWDesignerWorkflowMapPane)this.m_activeMapPane).deleteSelectedItems();
        }
        return false;
    }

    public void newMap() {
        boolean bError = true;
        VWNewMapDialog dlg = new VWNewMapDialog(this.m_authPropertyData.getMainContainer(), this.m_workflowDefinition, this.m_baseWorkflowDefinition);
        while (bError) {
            dlg.setVisible(true);
            try {
                if (dlg.getStatus() == 0) {
                    VWMapDefinition copyOfParentMap;
                    if (this.m_workflowDefinition == null) continue;
                    if (dlg.getMapType() == 0) {
                        VWMapDefinition newMap;
                        String mapName = dlg.getMapName();
                        if (mapName.length() <= 0 || dlg.getMapType() == 0 && VWDesignerWorkflowPane.isSystemMap(mapName) && JOptionPane.showConfirmDialog(dlg, VWResource.s_overrideInheritedMapQuestionStr, VWResource.s_createSubmap, 0) == 1 || (newMap = this.m_authPropertyData.createMapDefinition(this, mapName, this)) == null) continue;
                        newMap.setDescription(dlg.getMapDescription());
                        bError = false;
                        continue;
                    }
                    VWMapDefinition parentMap = dlg.getSelectedParentMap();
                    if (parentMap == null || (copyOfParentMap = this.m_authPropertyData.overrideMapDefinition(this, parentMap.getName(), this)) == null) continue;
                    copyOfParentMap.setDescription(dlg.getMapDescription());
                    bError = false;
                    continue;
                }
                bError = false;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
            }
        }
    }

    public void deleteMap(String mapName) {
        try {
            VWMapDefinition testMapDef;
            if (mapName == null) {
                mapName = this.getActiveMapPane().getMapName();
            }
            String msg = null;
            msg = this.checkMapIsUsing(mapName) ? VWResource.s_mapIsReferenced + "  " + VWResource.s_continueQuestionStr : VWResource.s_mapIsNotReferenced + "  " + VWResource.s_continueQuestionStr;
            int nResult = JOptionPane.showConfirmDialog(this.m_authPropertyData.getMainContainer(), msg, VWResource.s_deleteCurrentSubmap, 0, 2);
            if (nResult == 0 && (testMapDef = this.m_workflowDefinition.getMap(mapName)) != null) {
                this.m_authPropertyData.deleteMapDefinition(this, mapName, this);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
        }
    }

    public void showGotoMapDialog() {
        try {
            String mapName;
            VWMapsDialog mapsDlg = new VWMapsDialog(this.m_authPropertyData.getMainContainer(), this.getActiveMapPane().getMapName(), this.m_mapCache);
            mapsDlg.setVisible(true);
            if (mapsDlg.getStatus() == 0 && (mapName = mapsDlg.getMapName()) != null) {
                this.m_authPropertyData.getToolbarActionNotifier().notifyToolbarAction(this, 503, mapName);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
        }
    }

    public String[] getMaps() {
        try {
            String[] mapNames = this.m_mapCache.getMapNames();
            if (mapNames != null) {
                VWMapNameUtil mapNameUtil = new VWMapNameUtil(this.m_mapCache);
                if (mapNameUtil != null) {
                    mapNames = mapNameUtil.getPrettyMapNames(mapNames);
                }
                return mapNames;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public String[] getCallerMaps(String currentMapName) {
        Object[] callerMapNames = null;
        try {
            VWMapDefinition[] mapDefs;
            if (this.m_workflowDefinition != null && (mapDefs = this.getMapDefinitions()) != null) {
                Vector<String> mapNames = new Vector<String>();
                for (int i = 0; i < mapDefs.length; ++i) {
                    VWMapNode[] mapNodes = mapDefs[i].getSteps();
                    if (mapNodes == null) continue;
                    for (int j = 0; j < mapNodes.length; ++j) {
                        int stepType = VWStepUtils.getStepType(mapNodes[j]);
                        if (stepType != 9 && stepType != 10 && stepType != 11 && stepType != 12 || (callerMapNames = VWStepUtils.getCalledMapNames(mapNodes[j])) == null) continue;
                        for (int k = 0; k < callerMapNames.length; ++k) {
                            if (VWStringUtils.compare((String)callerMapNames[k], currentMapName) != 0) continue;
                            boolean found = false;
                            if (mapNames.size() > 0) {
                                String name = mapDefs[i].getName();
                                for (int l = 0; l < mapNames.size(); ++l) {
                                    if (VWStringUtils.compare((String)mapNames.elementAt(l), name) != 0) continue;
                                    found = true;
                                    break;
                                }
                                if (found) continue;
                                mapNames.addElement(name);
                                continue;
                            }
                            mapNames.addElement(mapDefs[i].getName());
                        }
                    }
                }
                int size = mapNames.size();
                if (size > 0) {
                    callerMapNames = new String[mapNames.size()];
                    mapNames.copyInto(callerMapNames);
                    if (size > 1) {
                        for (int i = 0; i < size; ++i) {
                            if (VWStringUtils.compare((String)callerMapNames[i], "Workflow") != 0) continue;
                            if (i == 0) break;
                            callerMapNames[i] = callerMapNames[0];
                            callerMapNames[0] = "Workflow";
                            break;
                        }
                    }
                    VWQuickSort quicksort = new VWQuickSort(callerMapNames, 0);
                    quicksort.sort(1, callerMapNames.length - 1);
                } else {
                    callerMapNames = null;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return callerMapNames;
    }

    public void addSelectedStepsToStepPalette() {
        if (this.m_activeMapPane != null && this.m_activeMapPane instanceof VWDesignerWorkflowMapPane) {
            ((VWDesignerWorkflowMapPane)this.m_activeMapPane).performAddToStepPaletteAction();
        }
    }

    public void setSelected() {
        if (this.m_stepPalettePanel != null) {
            this.m_stepPalettePanel.setSelected();
        }
    }

    public void releaseReferences() {
        this.m_authPropertyData.getMapChangeEventNotifier().removeMapChangedListener(this);
        this.m_authPropertyData.getToolbarActionNotifier().removeToolbarActionListener(this);
        super.removeReferences();
    }

    public void mapChanged(VWMapChangedEvent event) {
        switch (event.getID()) {
            case 516: {
                this.onAddedMap(event.getEventParams());
                break;
            }
            case 519: {
                this.onRenamedMap(event.getEventParams());
                break;
            }
            case 517: {
                this.onRemovedMap(event.getEventParams());
            }
        }
    }

    public void toolbarActionPerformed(VWToolbarActionEvent event) {
        switch (event.getID()) {
            case 660: {
                if (this.m_activeMapPane == null || !(this.m_activeMapPane instanceof VWDesignerWorkflowMapPane)) break;
                VWMapNode newMapNode = (VWMapNode)event.getParam();
                ((VWDesignerWorkflowMapPane)this.m_activeMapPane).createNewStep(newMapNode, VWDesignerWorkflowMapPane.DEFAULT_STEP_LOCATION);
                break;
            }
            case 661: {
                if (this.m_activeMapPane == null || !(this.m_activeMapPane instanceof VWDesignerWorkflowMapPane)) break;
                ((VWDesignerWorkflowMapPane)this.m_activeMapPane).createNewTextAnnotation(VWDesignerWorkflowMapPane.DEFAULT_TEXT_ANNOTATION_LOCATION);
            }
        }
    }

    protected VWBaseMapToolbar newMapToolbar() {
        if (this.m_mapToolbar == null) {
            this.m_mapToolbar = new VWDesignerMapToolbar(this, this.m_stepPalettePanel, this.m_processCanvasPanel);
            this.m_mapToolbar.setName("m_mapToolbar_VWDesignerWorkflowPane");
        }
        return this.m_mapToolbar;
    }

    protected VWBaseWorkflowMapPane newMapPane() {
        return new VWDesignerWorkflowMapPane(this.m_authPropertyData, this);
    }

    protected VWWorkflowScrollPane newScrollPane() {
        if (this.m_scrollPane == null) {
            this.m_scrollPane = new VWDesignerWorkflowScrollPane();
            this.m_scrollPane.setName("m_scrollPane_VWDesignerWorkflowPane");
        }
        return this.m_scrollPane;
    }

    protected VWMapAttribs newMapAttributes() {
        return this.m_mapAttribs;
    }

    protected boolean checkMapIsUsing(String checkMapName) {
        try {
            VWMapDefinition[] mapDefs;
            if (this.m_workflowDefinition != null && (mapDefs = this.getMapDefinitions()) != null) {
                for (int i = 0; i < mapDefs.length; ++i) {
                    VWMapNode[] mapNodes = mapDefs[i].getSteps();
                    if (mapNodes == null) continue;
                    block6: for (int j = 0; j < mapNodes.length; ++j) {
                        switch (VWStepUtils.getStepType(mapNodes[j])) {
                            case 9: 
                            case 10: 
                            case 11: 
                            case 12: {
                                boolean bFound = VWStepUtils.isMapReferenced(checkMapName, mapNodes[j]);
                                if (!bFound) continue block6;
                                return true;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    protected void addStepToPalette(VWMapNode vwMapNode) {
        if (this.m_stepPalettePanel != null) {
            try {
                this.m_stepPalettePanel.addStepToPalette(null, vwMapNode);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
            }
        }
    }

    protected VWPrintableWFProperty getPrintableWFProperty(Graphics theGraphics) {
        boolean bPrintAll = this.m_authPropertyData.getDesignerCoreData().getApplicationMode() == 1;
        return new VWPrintableWFProperty(this.m_mapCache, this.m_workflowDefinition, theGraphics, bPrintAll);
    }

    protected void bindStepRouteProperty(VWBaseWorkflowMapPane mapPane, Graphics g) throws Exception {
        String activeMapName = mapPane.getMapName();
        VWMapDefinition currentMapDef = this.m_mapCache.getMapDefinition(activeMapName);
        VWMapNode[] nodeList = currentMapDef.getSteps();
        if (nodeList != null) {
            boolean bPrintAll = this.m_authPropertyData.getDesignerCoreData().getApplicationMode() == 1;
            for (int i = 0; i < nodeList.length; ++i) {
                VWPrintableStepProperty stepPrintable = new VWPrintableStepProperty(nodeList[i], g, mapPane.getMap(), this.m_vwPrinter, bPrintAll);
                stepPrintable.bindBook();
            }
        }
    }

    private void onAddedMap(Vector mapList) {
        try {
            Object obj;
            if (mapList != null && !mapList.isEmpty() && (obj = mapList.firstElement()) != null && obj instanceof VWMapDefinition) {
                VWMapDefinition mapDef = (VWMapDefinition)obj;
                this.m_mapToolbar.initMapCombo(this.m_mapCache.toVector());
                this.m_mapToolbar.selectMap(this.findMap(mapDef.getName()));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onRemovedMap(Vector mapNameList) {
        try {
            Object obj;
            if (mapNameList != null && !mapNameList.isEmpty() && (obj = mapNameList.firstElement()) != null && obj instanceof String) {
                String mapName = (String)obj;
                this.m_mapToolbar.initMapCombo(this.m_mapCache.toVector());
                if (this.m_mapCache.getMapDefinition(mapName) == null) {
                    mapName = "Workflow";
                }
                this.m_mapToolbar.selectMap(this.findMap(mapName));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onRenamedMap(Vector mapNameList) {
        try {
            if (mapNameList != null && mapNameList.size() > 0) {
                String newMapName = (String)mapNameList.elementAt(1);
                this.m_mapToolbar.initMapCombo(this.m_mapCache.toVector());
                VWMap map = this.findMap(newMapName);
                this.m_mapToolbar.selectMap(map);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

